/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedStairsModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final StairsShape shape;

    public FramedStairsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.top = state.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        this.shape = (StairsShape)state.m_61143_((Property)BlockStateProperties.f_61398_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (this.top && quadDir == Direction.DOWN || !this.top && quadDir == Direction.UP) {
            this.createCenterQuads(quadMap.get(null), quad);
            this.createTopBottomQuads(quadMap.get(quadDir), quad);
        } else if (!Utils.isY(quad.m_111306_())) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(quadDir));
            this.createSideQuads(quadMap, quad, quadDir);
        }
    }

    private void createCenterQuads(List<BakedQuad> quadList, BakedQuad quad) {
        if (this.shape == StairsShape.STRAIGHT || this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadList);
        }
        if (this.shape != StairsShape.STRAIGHT) {
            boolean opposite = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT;
            boolean left = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.INNER_LEFT;
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(opposite ? this.dir.m_122424_() : this.dir, 0.5f)).apply(Modifiers.cutTopBottom(left ? this.dir.m_122428_() : this.dir.m_122427_(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadList);
        }
    }

    private void createTopBottomQuads(List<BakedQuad> quadList, BakedQuad quad) {
        if (this.shape == StairsShape.STRAIGHT || this.shape == StairsShape.INNER_LEFT || this.shape == StairsShape.INNER_RIGHT) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f)).export(quadList);
        }
        if (this.shape != StairsShape.STRAIGHT) {
            boolean outer = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT;
            boolean left = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.INNER_LEFT;
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(outer ? this.dir.m_122424_() : this.dir, 0.5f)).apply(Modifiers.cutTopBottom(left ? this.dir.m_122427_() : this.dir.m_122428_(), 0.5f)).export(quadList);
        }
    }

    private void createSideQuads(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction quadDir) {
        boolean left;
        boolean inner = this.shape == StairsShape.INNER_LEFT || this.shape == StairsShape.INNER_RIGHT;
        boolean bl = left = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.INNER_LEFT;
        if (quadDir == this.dir.m_122424_()) {
            Direction cutDir = left != inner ? this.dir.m_122427_() : this.dir.m_122428_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).applyIf(Modifiers.cutSideLeftRight(cutDir, 0.5f), this.shape != StairsShape.STRAIGHT).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            if (inner) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(left ? this.dir.m_122427_() : this.dir.m_122428_(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.dir && !inner) {
            Direction cutDir = left ? this.dir.m_122427_() : this.dir.m_122428_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir.m_122434_() != this.dir.m_122434_()) {
            boolean innerRight;
            boolean outerLeft = this.shape == StairsShape.OUTER_LEFT && quadDir == this.dir.m_122427_();
            boolean outerRight = this.shape == StairsShape.OUTER_RIGHT && quadDir == this.dir.m_122428_();
            boolean innerLeft = this.shape == StairsShape.INNER_LEFT && quadDir == this.dir.m_122427_();
            boolean bl2 = innerRight = this.shape == StairsShape.INNER_RIGHT && quadDir == this.dir.m_122428_();
            if (this.shape == StairsShape.STRAIGHT || !inner || innerLeft || innerRight) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), outerLeft || outerRight).export(quadMap.get(outerLeft || outerRight ? null : quadDir));
            }
            if (innerLeft || innerRight) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        }
    }
}

